(function() {
  //Rafa Dorado Farmerswife  08/01/2014
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'mobiscroll', 'collections/contacts/ContactCollection', 'views/contact/ContactListView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, Mobiscroll, ContactCollection, ContactListView) {
    var CustomFieldView;
    return CustomFieldView = (function() {
      class CustomFieldView extends Backbone.View {
        initialize(usr, cf, context, parentView) {
          this.usr = usr;
          this.cf = cf;
          this.context = context;
          this.parentView = parentView;
        }

        events() {
          return {
            'tap .btn-date-cfield': 'btnDateClicked',
            'change .input-date-cfield': 'inputDateChanged',
            'change .radio-selector-cfield': 'btnSelectorClicked',
            'tap .btn-contact-cfield': 'btnContactClicked'
          };
        }

        render() {
          var html_cfield, template;
          template = Handlebars.templates['CField'];
          if (this.context === 'form') {
            html_cfield = this.__get_html_for_cfield();
          } else {
            html_cfield = this.__get_value_for_cfield();
          }
          this.$el.html(template({
            context: this.context,
            label: this.cf.label,
            html_cfield: html_cfield
          }));
          return this;
        }

        /* DATE CFIELD FORM CONTEXT*/
        btnDateClicked(event) {
          var cur, inputObj;
          event.stopPropagation();
          event.preventDefault();
          cur = $(event.currentTarget);
          inputObj = cur.siblings('.input-date-cfield');
          inputObj.mobiscroll().date({
            theme: 'Android',
            display: 'bottom',
            dateFormat: 'yy-mm-dd',
            dateOrder: 'ddmmyy',
            maxDate: window.MAXDATE
          });
          return inputObj.mobiscroll('show');
        }

        inputDateChanged(event) {
          var cur, span;
          cur = $(event.currentTarget);
          span = cur.siblings('.btn-date-cfield');
          return span.text(cur.val());
        }

        /* SELECTOR WIDGET CLICKED */
        btnSelectorClicked(event) {
          var cur, input;
          event.stopPropagation();
          event.preventDefault();
          cur = $(event.currentTarget);
          input = cur.parentsUntil('fieldset').find('.input-selector-cfield');
          if (input) {
            return input.val(cur.val());
          }
        }

        btnContactClicked(event) {
          var cur, view;
          event.stopPropagation();
          event.preventDefault();
          cur = $(event.currentTarget);
          cur.attr('data-selected', true);
          if (!ContactListView) {
            ContactListView = require('views/contact/ContactListView');
          }
          if (!this.parentView) {
            this.parentView = 'AddProjectCFields';
          }
          view = new ContactListView(this.usr, this.parentView);
          return $.mobile.jqmNavigator.pushView(view, {
            transition: 'none'
          });
        }

        /* HTML GENERATORS */
        __get_html_for_cfield() {
          var companies, html, sel, value;
          this.$el.attr('data-label', this.cf.label);
          this.$el.attr('data-type', this.cf.type);
          html = '';
          value = this.cf.value;
          switch (this.cf.type) {
            case 'checkbox':
              if ("value" in this.cf) {
                html = '<select class="selector-checkbox-cfield">';
                if (value === 0) {
                  html += "<option value='0' selected='selected'>No</option><option value='1'>Yes</option>";
                } else {
                  html += "<option value='0' >No</option><option value='1' selected='selected'>Yes</option>";
                }
                html += '</select>';
              } else {
                html = '<select class="selector-checkbox-cfield"><option value="1">Yes</option><option value="0">No</option></select>';
              }
              break;
            case 'date':
              if (value) {
                html = `<span class=\"btn btn-date-cfield\">${value}</span><input type=\"hidden\" class=\"input-date-cfield\" value=\"${value}\"/>`;
              } else {
                html = '<span class="btn btn-date-cfield">Select a Date</span><input type="hidden" class="input-date-cfield" />';
              }
              break;
            case 'text':
              if (value) {
                html = `<textarea class=\"text-cfield\">${value}</textarea>`;
              } else {
                html = '<textarea class="text-cfield"></textarea>';
              }
              break;
            case 'entry':
              //ORDER OF IMPORTANCY CONTACT > COMPANY
              if (this.cf.canLinkToContact) {
                if (!this.cf.value) {
                  html = '<a href="#" data-role="button" class="btn-contact-cfield" data-selected="false">Select a Contact</a>';
                } else {
                  html = `<a href='#' data-role='button' class='btn-contact-cfield' data-selected='false' >${this.cf.value}</a>`;
                }
              } else if (this.cf.canLinkToCompany) {
                sel = '<select class="selector-company-cfield">';
                companies = JSON.parse('[' + window.localStorage.getItem('CompanyList') + ']');
                if (!window.localStorage.getItem('CompanyList')) {
                  this.__get_company_list();
                } else {
                  _.each(companies, (comp) => {
                    var opt, selected;
                    if (comp.name === this.cf.value) {
                      selected = 'selected=selected';
                    } else {
                      selected = '';
                    }
                    opt = `<option value=\"${comp.companyID}\" ${selected}>${comp.name}</option> `;
                    return sel += opt;
                  });
                }
                sel += '</select>';
                html = sel;
              } else {
                if (value) {
                  html = `<input type=\"text\" class=\"entry-cfield\" value='${value}'>`;
                } else {
                  html = '<input type="text" class="entry-cfield">';
                }
              }
              break;
            case 'selector':
              html = ' <fieldset data-role="controlgroup" class="selector-cfield">';
              if (this.cf.canAllowOther) {
                if (value) {
                  html += `<input type=\"text\" class=\"input-selector-cfield\" value=\"${value}\"/>`;
                } else {
                  html += '<input type="text" class="input-selector-cfield" />';
                }
              } else {
                html += '<input type="text" class="input-selector-cfield" style="display: none;"/>';
              }
              _.each(this.cf.optionValue, (val) => {
                var checked;
                checked = this.cf.value === val ? checked = 'checked="checked"' : '';
                html += `<input type='radio' class='radio-selector-cfield' name=\"${this.cf.label}-radio-cfield\" id=\"${this.cf.label}-radio-choice-${val}\" value=\"${val}\" ${checked}/>`;
                return html += `<label for=\"${this.cf.label}-radio-choice-${val}\">${val}</label>`;
              });
              html += '</fieldset>';
          }
          return html;
        }

        __get_value_for_cfield() {
          var value;
          //TODO VALUE OF SELECT
          switch (this.cf.type) {
            case 'checkbox':
              if (this.cf.value === 0) {
                value = 'No';
              } else if (this.cf.value === 1) {
                value = 'Yes';
              } else {
                value = '---';
              }
              break;
            case 'date':
              value = Moment(this.cf.value).format('dddd, MMMM Do YYYY');
              break;
            default:
              value = this.cf.value ? String(this.cf.value).replace(/(\r\n|\n|\r)/gm, "<br>") : "";
          }
          if (value === 'undefined') {
            value = 'No';
          }
          return value;
        }

        __get_company_list() {
          var contactsCol;
          if (!ContactCollection) {
            ContactCollection = require('collections/contacts/ContactCollection');
          }
          contactsCol = new ContactCollection();
          contactsCol.get_companies(this.usr);
          return contactsCol.on('companies_filled', this.__fill_company_select, this);
        }

        __fill_company_select() {
          var companies, sel;
          sel = this.$el.find('.selector-company-cfield');
          sel.empty();
          companies = JSON.parse('[' + window.localStorage.getItem('CompanyList') + ']');
          _.each(companies, function(comp) {
            var opt;
            opt = `<option value=\"${comp.companyID}\">${comp.name}</option> `;
            return sel.append(opt);
          });
          sel.selectmenu();
          sel.selectmenu('refresh');
          return $('#id-divAddBookingCFields').trigger('create');
        }

      };

      //console.log "#{@cf.label} #{@cf.type}"
      CustomFieldView.prototype.tagName = "li";

      CustomFieldView.prototype.className = 'liBookingCustomField';

      return CustomFieldView;

    }).call(this);
  });

}).call(this);
